<?php

require __DIR__ . '/autoload.php';
use Doctrine\DBAL\Tools\Console\Helper\ConnectionHelper;
use Ministra\Admin\Command\AnalyzingRoutesCommand;
use Ministra\Admin\Command\ClearCacheCommand;
use Ministra\Admin\Command\DeployMigrationsCommand;
use Ministra\Admin\Command\GenerateRoutesCommand;
use Ministra\Admin\Command\UpdateClearUtilCommand;
use Ministra\Admin\Command\UpgradeMigrationsCommand;
use Ministra\Admin\DoctrineServiceProvider;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\K742a59a6920daf29d990617caf741c43\k2f8f05a14598b58578672715296492a8;
use Silex\Provider\SerializerServiceProvider;
use Symfony\Component\Console\Application;
use Symfony\Component\Console\Helper\HelperSet;
use Symfony\Component\Console\Helper\QuestionHelper;
require __DIR__ . '/../app.php';
if (isset($app)) {
    $app->register(new \Silex\Provider\SerializerServiceProvider());
    $cli = new \Symfony\Component\Console\Application();
    $db = $app['db'];
    $app->register(new \Ministra\Admin\DoctrineServiceProvider($cli), ['migrations.directory' => __DIR__ . '/../src/Migrations', 'migrations.name' => 'Ministra DB Migrations', 'migrations.namespace' => 'Ministra\\Migrations', 'migrations.table_name' => 'changelog']);
    $helperSet = new \Symfony\Component\Console\Helper\HelperSet(['connection' => new \Doctrine\DBAL\Tools\Console\Helper\ConnectionHelper($app['db']), 'dialog' => new \Symfony\Component\Console\Helper\QuestionHelper()]);
    require __DIR__ . '/../config/boot_app.php';
    $cli->setHelperSet($helperSet);
    $cli->add((new \Ministra\Admin\Command\GenerateRoutesCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add(new \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\K742a59a6920daf29d990617caf741c43\k2f8f05a14598b58578672715296492a8());
    $cli->add((new \Ministra\Admin\Command\AnalyzingRoutesCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\UpgradeMigrationsCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\DeployMigrationsCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\UpdateClearUtilCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\ClearCacheCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->run();
}
