<?php

namespace Ministra\Admin;

use Doctrine\DBAL\DriverManager;
use Ministra\Admin\Adapter\DataTableAdapter;
use Ministra\Admin\Container\SilexPsrContainer;
use Ministra\Admin\Lib\Middleware\Pipelines;
use Ministra\Admin\Repository\LicenseKeysRepository;
use Ministra\Admin\Repository\ServicesPackageRepository;
use Ministra\Admin\Repository\TariffPlanRepository;
use Ministra\Admin\Service\ServicesPackageGrid;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\d4af485b4b1592ac81fa6cf6c06b5beb;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\k174df9e5f53f2cb41aae7954e0210720\aed877ed4449a2ce74830a9ff060a8d3;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\e5a3d844e403add01bdce61d9b1892ec as CoreLicenseKeysRepository;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\i19cebf739a08f54d1754998b01d60a01;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\V01425e72e042eec03b124fafddc30800;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\A7929dba3fa1e1ff2574045bff0470446;
use Pimple\Container;
use Pimple\ServiceProviderInterface;
use Psr\Container\ContainerInterface;
use Silex\Application;
class AppServiceProvider implements \Pimple\ServiceProviderInterface
{
    public function register(\Pimple\Container $container)
    {
        $container->offsetSet(\Psr\Container\ContainerInterface::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Container\SilexPsrContainer($app);
        });
        $container->offsetSet('pipelines', function (\Silex\Application $app) {
            return new \Ministra\Admin\Lib\Middleware\Pipelines();
        });
        $this->registerRepository($container);
        $container->offsetSet(\Ministra\Admin\Adapter\DataTableAdapter::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Adapter\DataTableAdapter($app['request_stack']->getCurrentRequest(), $app['db']);
        });
        $this->registerUtilConnection($container);
        $this->registerUtilService($container);
    }
    protected function registerRepository(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Admin\Repository\LicenseKeysRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\LicenseKeysRepository($app['db']);
        });
        $container->offsetSet(\Ministra\Admin\Repository\TariffPlanRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\TariffPlanRepository($app['db']);
        });
        $container->offsetSet(\Ministra\Admin\Repository\ServicesPackageRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\ServicesPackageRepository($app['db']);
        });
        $container->offsetSet(\Ministra\Admin\Service\ServicesPackageGrid::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Service\ServicesPackageGrid($app[\Ministra\Admin\Adapter\DataTableAdapter::class], $app[\Ministra\Admin\Repository\ServicesPackageRepository::class], $app[\Ministra\Admin\Repository\TariffPlanRepository::class]);
        });
    }
    protected function registerUtilConnection(\Pimple\Container $container)
    {
        $file = \realpath(__DIR__ . '/../../') . '/deploy/clear_key_util/db_util.sqlite';
        if (!\file_exists($file)) {
            \file_put_contents($file, '');
        }
        if (!\is_writable($file)) {
            throw new \RuntimeException("Clear key util database file does not writable: {$file}");
        }
        $dirs = [\dirname($file) . '/logs', \dirname($file) . '/reports'];
        foreach ($dirs as $dir) {
            if (!\is_writable($file)) {
                throw new \RuntimeException("Directory does not writable: {$dir}");
            }
        }
        if (!\extension_loaded('pdo_sqlite')) {
            throw new \Exception('SQLite extension missing');
        }
        $container->offsetSet('util.connection', \Doctrine\DBAL\DriverManager::getConnection(['driver' => 'pdo_sqlite', 'path' => $file]));
    }
    protected function registerUtilService(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\V01425e72e042eec03b124fafddc30800::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\V01425e72e042eec03b124fafddc30800($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\i19cebf739a08f54d1754998b01d60a01::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\i19cebf739a08f54d1754998b01d60a01($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\k174df9e5f53f2cb41aae7954e0210720\aed877ed4449a2ce74830a9ff060a8d3::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\e5a3d844e403add01bdce61d9b1892ec($app['db']);
        });
        $container->offsetSet(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\d4af485b4b1592ac81fa6cf6c06b5beb::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\d4af485b4b1592ac81fa6cf6c06b5beb($app->offsetGet(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\i19cebf739a08f54d1754998b01d60a01::class), $app->offsetGet(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\b339bcd43642528a2f7e35b19e128bd7\V01425e72e042eec03b124fafddc30800::class), $app->offsetGet(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\k174df9e5f53f2cb41aae7954e0210720\aed877ed4449a2ce74830a9ff060a8d3::class), \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\n9658df13bf979bc50261be83dbd2864d\A7929dba3fa1e1ff2574045bff0470446::G8c7d4d7d034a3bb174fea551f7942a01, $app->offsetGet('util.path'));
        });
    }
}
