<?php

namespace Ministra\Admin;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\w845d00e5e868e310b57a6544b77e6aae;
use Moust\Silex\Provider\CacheServiceProvider as MCacheServiceProvider;
use Pimple\Container;
class CacheServiceProvider extends \Moust\Silex\Provider\CacheServiceProvider
{
    public function register(\Pimple\Container $app)
    {
        $options = $app->offsetExists('memcache.options') ? $app['memcache.options'] : ['memcache.options' => ['host' => '127.0.0.1', 'default_timeout' => 1800]];
        if (null !== ($instance = $this->checkMemcacheConnect($options['memcache.options']['host']))) {
            $app['caches.options'] = ['memcache' => ['driver' => \get_class($instance) === 'Memcache' ? 'memcache' : 'memcached', 'memcache' => function () use($instance) {
                return $instance;
            }]];
        } else {
            $app['caches.options'] = ['filesystem' => ['driver' => 'file', 'cache_dir' => __DIR__ . '/../resources/cache/admin']];
        }
        return parent::register($app);
    }
    private function checkMemcacheConnect($hosts)
    {
        if (!\class_exists('Memcache') && !\class_exists('Memcached')) {
            return null;
        }
        $memcache = \class_exists('Memcached') ? new \Memcached() : new \Memcache();
        if (!\is_array($hosts)) {
            $hosts = [$hosts];
        }
        $countDisabled = 0;
        foreach ($hosts as $host) {
            if ($memcache->addServer($host, 11211) && $memcache->getStats() && $memcache->set('test', '123')) {
                $memcache->delete('test');
            } else {
                ++$countDisabled;
                \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\w845d00e5e868e310b57a6544b77e6aae::z3182eef79ddc9f24d927475892878e57('Could not connect to memcached. Host: ' . $host);
            }
        }
        return $countDisabled === \count($hosts) ? null : $memcache;
    }
}
