<?php

namespace Ministra\Admin\Model;

class EventsModel extends \Ministra\Admin\Model\BaseMinistraModel
{
    public function __construct()
    {
        parent::__construct();
    }
    public function getTotalRowsEventsList($where = [], $like = [])
    {
        if (!empty($this->reseller_id)) {
            $where['reseller_id'] = $this->reseller_id;
        }
        $this->mysqlInstance->count()->from('events');
        if (!empty($where) || !empty($like)) {
            $this->mysqlInstance->join('users', 'events.uid', 'users.id', 'LEFT');
        }
        $this->mysqlInstance->where($where);
        if (!empty($like)) {
            $this->mysqlInstance->like($like, 'OR');
        }
        return $this->mysqlInstance->get()->counter();
    }
    public function getEventsList($param)
    {
        if (!empty($this->reseller_id)) {
            $param['where']['reseller_id'] = $this->reseller_id;
        }
        if (!empty($param['select'])) {
            $this->mysqlInstance->select($param['select']);
        }
        $this->mysqlInstance->from('events')->join('users', 'events.uid', 'users.id', 'LEFT')->where($param['where'])->like($param['like'], 'OR')->orderby($param['order']);
        if (!empty($param['limit']['limit'])) {
            $this->mysqlInstance->limit($param['limit']['limit'], \array_key_exists('offset', $param['limit']) ? $param['limit']['offset'] : null);
        }
        return $this->mysqlInstance->get()->all();
    }
    public function getUser($param = [], $all = false)
    {
        $where = [];
        if (!empty($this->reseller_id)) {
            $where['reseller_id'] = $this->reseller_id;
        }
        if ($all !== false) {
            return $this->mysqlInstance->from('users')->where($param, 'OR')->where($where)->get()->all();
        }
        return $this->mysqlInstance->from('users')->where($param, 'OR')->where($where)->get()->first();
    }
    public function getConsoleGroup($param = [])
    {
        if (!empty($this->reseller_id)) {
            $param['reseller_id'] = $this->reseller_id;
        }
        return $this->mysqlInstance->from('stb_groups')->where($param)->get()->all();
    }
    public function getConsoleInGroup($param = [])
    {
        return $this->mysqlInstance->from('stb_in_group')->where($param)->get()->all();
    }
    public function updateUser($params, $where)
    {
        if (!empty($this->reseller_id)) {
            $where['reseller_id'] = $this->reseller_id;
        }
        return $this->mysqlInstance->where($where)->update('users', $params)->total_rows();
    }
    public function deleteEventsByUID($uid)
    {
        if (empty($this->reseller_id)) {
            return $this->mysqlInstance->delete('events', ['uid' => $uid])->total_rows();
        }
        $users = [];
        foreach ($this->getUser(['id' => $uid], 'ALL') as $row) {
            $users[] = $row['id'];
        }
        return $this->mysqlInstance->in('uid', $users)->delete('events', [])->total_rows();
    }
    public function deleteAllEvents()
    {
        if (empty($this->reseller_id)) {
            return $this->mysqlInstance->query('TRUNCATE TABLE `events`') ? 'all' : 0;
        }
        $users = [];
        foreach ($this->getUser([], 'ALL') as $row) {
            $users[] = $row['id'];
        }
        return $this->mysqlInstance->in('uid', $users)->delete('events', [])->total_rows();
    }
    public function getTotalRowsMsgTemplates($where = [], $like = [])
    {
        $params = ['where' => $where];
        if (!empty($like)) {
            $params['like'] = $like;
        }
        return $this->getMsgTemplates($params, true);
    }
    public function getMsgTemplates($param, $counter = false)
    {
        if (!empty($param['select'])) {
            $this->mysqlInstance->select($param['select']);
        }
        $this->mysqlInstance->from('messages_templates as M_T')->join('administrators as A', 'M_T.author', 'A.id', 'LEFT');
        if (!empty($param['where'])) {
            $this->mysqlInstance->where($param['where']);
        }
        if (!empty($where)) {
            $this->mysqlInstance->where($where, ' OR ');
        }
        if (!empty($param['like'])) {
            $this->mysqlInstance->like($param['like'], ' OR ');
        }
        if (!empty($param['order'])) {
            $this->mysqlInstance->orderby($param['order']);
        }
        if (!empty($param['limit']['limit'])) {
            $this->mysqlInstance->limit($param['limit']['limit'], $param['limit']['offset']);
        }
        return $counter ? $this->mysqlInstance->count()->get()->counter() : $this->mysqlInstance->get()->all();
    }
    public function insertMsgTemplate($params)
    {
        return $this->mysqlInstance->insert('messages_templates', $params)->insert_id();
    }
    public function updateMsgTemplate($params, $id)
    {
        $where = ['id' => $id];
        if (!empty($this->admin_login) && $this->admin_login != 'admin') {
            $where['author'] = $this->admin_id;
        }
        return $this->mysqlInstance->update('messages_templates', $params, $where)->total_rows();
    }
    public function deleteMsgTemplate($id)
    {
        $where = ['id' => $id];
        if (!empty($this->admin_login) && $this->admin_login != 'admin') {
            $where['author'] = $this->admin_id;
        }
        return $this->mysqlInstance->delete('messages_templates', $where)->total_rows();
    }
    public function getFilterSet($params)
    {
        return $this->mysqlInstance->from('filter_set')->where($params)->get()->all();
    }
    public function getTotalRowsScheduleEvents($where = [], $like = [])
    {
        $params = ['where' => $where];
        if (!empty($like)) {
            $params['like'] = $like;
        }
        return $this->getScheduleEvents($params, true);
    }
    public function getScheduleEvents($param, $counter = false)
    {
        if (!empty($param['select'])) {
            $this->mysqlInstance->select($param['select']);
        }
        $this->mysqlInstance->from('schedule_events as S_E');
        if (!empty($param['where'])) {
            $this->mysqlInstance->where($param['where']);
        }
        if (!empty($where)) {
            $this->mysqlInstance->where($where, ' OR ');
        }
        if (!empty($param['like'])) {
            $this->mysqlInstance->like($param['like'], ' OR ');
        }
        if (!empty($param['order'])) {
            $this->mysqlInstance->orderby($param['order']);
        }
        if (!empty($param['limit']['limit'])) {
            $this->mysqlInstance->limit($param['limit']['limit'], $param['limit']['offset']);
        }
        return $counter ? $this->mysqlInstance->count()->get()->counter() : $this->mysqlInstance->get()->all();
    }
    public function insertScheduleEvents($params)
    {
        return $this->mysqlInstance->insert('schedule_events', $params)->insert_id();
    }
    public function updateScheduleEvents($params, $id)
    {
        $where = ['id' => $id];
        return $this->mysqlInstance->update('schedule_events', $params, $where)->total_rows();
    }
    public function deleteScheduleEvents($id)
    {
        $where = ['id' => $id];
        return $this->mysqlInstance->delete('schedule_events', $where)->total_rows();
    }
}
