<?php

namespace Ministra\Admin\Repository;

use Doctrine\DBAL\Connection;
class TariffPlanRepository
{
    const TARIFF_PLAN_TABLE = 'tariff_plan';
    private $connection;
    public function __construct(\Doctrine\DBAL\Connection $connection)
    {
        $this->connection = $connection;
    }
    public function countUsersPerPackages(array $ids)
    {
        $query = <<<SQL
SELECT 
    package_id,
    SUM(
        (SELECT COUNT(*)
        FROM users
        WHERE (tariff_plan_id = tp.id) || IF(tp.user_default = 1, tariff_plan_id = 0, false))
    ) AS user_cont
FROM package_in_plan AS pp
LEFT JOIN tariff_plan AS tp ON pp.plan_id = tp.id
WHERE optional = 0 AND package_id in (:ids) 
group by package_id
SQL;
        return $this->connection->executeQuery($query, ['ids' => $ids], ['ids' => \Doctrine\DBAL\Connection::PARAM_INT_ARRAY])->fetchAll();
    }
    public function countUsersPerSubscription(array $ids)
    {
        $query = <<<SQL
select package_id, count(id) as cnt
from user_package_subscription 
where package_id in (:ids) 
group by package_id
SQL;
        return $this->connection->executeQuery($query, ['ids' => $ids], ['ids' => \Doctrine\DBAL\Connection::PARAM_INT_ARRAY])->fetchAll();
    }
}
