<?php

namespace Ministra\Lib;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
use Ministra\Lib\Course\CourseGetter;
use Ministra\Lib\Course\ProviderFactory;
class Course implements \Ministra\Lib\StbApi\Course
{
    private $db;
    private $codes;
    private $providerName;
    public function __construct()
    {
        $this->db = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance();
        $this->providerName = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::get('course_provider');
        $providers = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::get('course_providers_for_update');
        if (\array_key_exists($this->providerName, $providers)) {
            $this->codes = $providers[$this->providerName];
        }
    }
    public function getData()
    {
        $provider = \Ministra\Lib\Course\ProviderFactory::build($this->providerName, [$this->codes, $this->db]);
        if ($provider instanceof \Ministra\Lib\Course\CourseGetter) {
            return $provider->getData();
        }
        throw new \Exception(\sprintf('Class "%s" must implement CourseGetter interface', \get_class($provider)));
    }
}
