<?php

namespace Ministra\Lib;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
class Google
{
    public $gapi_name;
    public $gapi_url;
    public $cache_expire = 3600;
    public $gapi_module;
    public $gapi_field;
    private $db;
    private $gapi_arr;
    private $cache_table;
    public function __construct()
    {
        $this->db = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance();
        $this->cache_table = 'gapi_cache_' . $this->gapi_name;
    }
    public function getData()
    {
        return $this->getDataFromDBCache();
    }
    private function getDataFromDBCache()
    {
        $content = $this->db->from($this->cache_table)->get()->first('content');
        $content = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::U14f6e17e22660d6a254d5165f6a0c21d(\base64_decode($content));
        if (\is_array($content)) {
            return $content;
        }
        return 0;
    }
    public function getDataFromGAPI()
    {
        $gapi_arr = [];
        $gapi_resp = \simplexml_load_file($this->gapi_url);
        if ($gapi_resp) {
            foreach ($gapi_resp->{$this->gapi_module}->{$this->gapi_field} as $item) {
                $new_item = [];
                foreach ($item as $field => $data) {
                    $new_item[$field] = (string) $data->attributes()->data;
                }
                $gapi_arr[] = $new_item;
            }
            $this->setDataDBCache($gapi_arr);
            return $gapi_arr;
        }
    }
    private function setDataDBCache($arr)
    {
        $content = \base64_encode(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::S5a834ad0c359b07af270f692de5f7106($arr));
        $result = $this->db->from($this->cache_table)->get();
        $crc = $result->get('crc');
        if (\md5($content) != $crc) {
            $data = ['content' => $content, 'updated' => 'NOW()', 'url' => $this->gapi_url, 'crc' => \md5($content)];
            if ($result->count() == 1) {
                $this->db->update($this->cache_table, $data);
            } else {
                $this->db->insert($this->cache_table, $data);
            }
        } else {
            if ($result->count() == 1) {
                $this->db->update($this->cache_table, ['updated' => 'NOW()']);
            }
        }
    }
}
