<?php

namespace Ministra\Lib;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a;
class ItvSubscription
{
    private static $itv_subscription = false;
    public static function getBonusChannelsIds($uid)
    {
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $bonus_ch = self::$itv_subscription['bonus_ch'];
        if (empty($bonus_ch)) {
            return [];
        }
        $bonus_ch_arr = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::U14f6e17e22660d6a254d5165f6a0c21d(\Ministra\Lib\System::base64_decode($bonus_ch));
        if (!\is_array($bonus_ch_arr)) {
            return [];
        }
        return $bonus_ch_arr;
    }
    public static function getSubscriptionChannelsIds($uid)
    {
        $user = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('users')->where(['id' => (int) $uid])->get()->first();
        if (empty($user)) {
            return [];
        }
        if (\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::getInstance()->z1fe0c5487d9008ab65e716bcfef6ab3d()) {
            return \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('itv')->where(['base_ch' => 0])->get()->all('id');
        }
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $sub_ch = self::$itv_subscription['sub_ch'];
        if (empty($sub_ch)) {
            return [];
        }
        $sub_ch_arr = @\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::U14f6e17e22660d6a254d5165f6a0c21d(\Ministra\Lib\System::base64_decode($sub_ch));
        if (!\is_array($sub_ch_arr)) {
            return [];
        }
        return $sub_ch_arr;
    }
    public static function updateByUids($uids, $data)
    {
        if (empty($data)) {
            return false;
        }
        if (!\array_key_exists('bonus_ch', $data) || !\is_array($data['bonus_ch'])) {
            $data['bonus_ch'] = [];
        }
        if (!\array_key_exists('sub_ch', $data) || !\is_array($data['sub_ch'])) {
            $data['sub_ch'] = [];
        }
        if (\array_key_exists('sub_ch', $data)) {
            $data['sub_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::S5a834ad0c359b07af270f692de5f7106($data['sub_ch']));
        }
        if (\array_key_exists('bonus_ch', $data)) {
            $data['bonus_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::S5a834ad0c359b07af270f692de5f7106($data['bonus_ch']));
        }
        $data['addtime'] = 'NOW()';
        $result = false;
        foreach ($uids as $uid) {
            $subscription = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
            if (empty($subscription)) {
                $result = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->insert('itv_subscription', \array_merge($data, ['uid' => $uid]));
            } else {
                $result = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->update('itv_subscription', $data, ['uid' => $uid]);
            }
        }
        if (!$result) {
            return false;
        }
        return self::getByUids($uids);
    }
    public static function getByUids($uids = [])
    {
        $result = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->select('itv_subscription.*, users.mac as mac, users.ls as ls, ' . 'users.additional_services_on as additional_services_on')->from('itv_subscription')->join('users', 'itv_subscription.uid', 'users.id', 'LEFT');
        if (!empty($uids)) {
            $result = $result->in('uid', $uids);
        }
        $result = $result->get()->all();
        $result = \array_map(function ($item) {
            $item['sub_ch'] = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::U14f6e17e22660d6a254d5165f6a0c21d(\Ministra\Lib\System::base64_decode($item['sub_ch']));
            $item['bonus_ch'] = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::U14f6e17e22660d6a254d5165f6a0c21d(\Ministra\Lib\System::base64_decode($item['bonus_ch']));
            return $item;
        }, $result);
        return $result;
    }
}
