<?php

namespace Ministra\Lib\RESTAPI\v1;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a;
class RESTCommandStbModules extends \Ministra\Lib\RESTAPI\v1\RESTCommand
{
    public function get(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        if (\count($stb_list) != 1) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Only one identifier allowed');
        }
        $uid = $stb_list[0];
        return ['disabled' => \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::H3b059d5438cece4939baca220ccf28df($uid), 'restricted' => \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::V7c11a5a183bd5b56cd8fd90d53dd02f9($uid)];
    }
    public function update(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        $uids = $stb_list;
        $data = $request->getPut();
        if (empty($data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('HTTP PUT data is empty');
        }
        if (!\array_key_exists('disabled', $data) && !\array_key_exists('restricted', $data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Update data is empty');
        }
        if (\array_key_exists('disabled', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::fb166ecb8bf39c8fc1ded147faeb422b($uid, $data['disabled']);
            }
        }
        if (\array_key_exists('restricted', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::fcffc71fec49b663aaf2837623e94ea0($uid, $data['restricted']);
            }
        }
        return ['disabled' => \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::H3b059d5438cece4939baca220ccf28df($uids[0]), 'restricted' => \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::V7c11a5a183bd5b56cd8fd90d53dd02f9($uids[0])];
    }
}
