<?php

namespace Ministra\Lib;

use ErrorException;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\a3b3126bac52bd78c794522ef07fb6ebf;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
class Storage
{
    private $storage;
    private $max_failures;
    private $stat_period;
    public function __construct($init_info = [])
    {
        if (empty($init_info)) {
            return;
        }
        if (!empty($init_info['id'])) {
            $this->storage = $this->getById($init_info['id']);
        } else {
            if (!empty($init_info['name'])) {
                $this->storage = $this->getByName($init_info['name']);
            }
        }
        if (empty($this->storage)) {
            throw new \ErrorException('Storage can not be initialized with values: ' . \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\a3b3126bac52bd78c794522ef07fb6ebf::a9ddcce2a276b16160c4bf651eabd9b5($init_info));
        }
        $this->max_failures = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::getSafe('max_storage_failures', 3);
        $this->stat_period = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::getSafe('storage_stat_period', 300);
    }
    public function getById($id)
    {
        return \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('storages')->where(['id' => $id])->get()->first();
    }
    public function getByName($name)
    {
        return \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('storages')->where(['storage_name' => $name])->get()->first();
    }
    public function markAsFailed($description = '')
    {
        $this->checkIfInitialized();
        \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->insert('storages_failure', ['storage_id' => $this->storage['id'], 'description' => $description])->insert_id();
        $failures = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('storages_failure')->count()->where(['storage_id' => $this->storage['id'], 'added>' => \date('Y-m-d H:i:s', \time() - $this->stat_period)])->get()->counter();
        if ($failures >= $this->max_failures) {
            $this->setOff();
        }
    }
    private function checkIfInitialized()
    {
        if (empty($this->storage)) {
            throw new \ErrorException('Storage not initialized');
        }
        return true;
    }
    public function setOff()
    {
        $this->checkIfInitialized();
        if ($this->storage['status'] == 0) {
            return true;
        }
        $result = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->update('storages', ['status' => 0], ['id' => $this->storage['id']]);
        if ($result) {
            \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->insert('master_log', ['log_txt' => 'Storage ' . $this->storage['storage_name'] . ' has been disabled after ' . $this->max_failures . ' failures in ' . $this->stat_period . 's', 'added' => 'NOW()']);
        }
        return $result;
    }
}
