<?php

namespace Ministra\Lib;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a;
class TvGenre
{
    private $language;
    public function setLocale($language)
    {
        $this->language = $language;
        \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::getInstance()->t46f357397dddca46b6b614fff4bfa589($this->language);
    }
    public function getById($id, $pretty_id = false)
    {
        if ($pretty_id) {
            $genres = $this->getAll($pretty_id, true);
            $genres = \array_filter($genres, function ($genre) use($id) {
                return $id == $genre['id'];
            });
            if (empty($genres)) {
                return;
            }
            $genres = \array_values($genres);
            return \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('tv_genre')->where(['id' => $genres[0]['_id']])->get()->first();
        }
        return \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('tv_genre')->where(['id' => (int) $id])->get()->first();
    }
    public function getAll($pretty_id = false, $include_internal_id = false)
    {
        $genres = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('tv_genre')->orderby('number')->get()->all();
        $genres = \array_map(function ($item) use($pretty_id, $include_internal_id) {
            if ($include_internal_id) {
                $item['_id'] = $item['id'];
            }
            if ($pretty_id) {
                $item['id'] = \preg_replace(["/\\s/i", '/[^a-z0-9-]/i'], ['-', ''], $item['title']);
            }
            $item['censored'] = (bool) $item['censored'];
            $item['title'] = \_($item['title']);
            return $item;
        }, $genres);
        return $genres;
    }
}
