<?php

namespace Ministra\Lib;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a;
class VideoCategory
{
    private $language;
    public function setLocale($language)
    {
        $this->language = $language;
        \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\w3071184ed28647d5b719a759c2f6492a::getInstance()->t46f357397dddca46b6b614fff4bfa589($this->language);
    }
    public function getById($id, $pretty_id = false)
    {
        if ($pretty_id) {
            $categories = $this->getAll($pretty_id);
            $categories = \array_filter($categories, function ($category) use($id) {
                return $id == $category['id'];
            });
            if (empty($categories)) {
                return;
            }
            $categories = \array_values($categories);
            $category = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('media_category')->where(['category_name' => $categories[0]['original_title']])->get()->first();
            if (!empty($category)) {
                $category['id'] = $id;
            }
            return $category;
        }
        return \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('media_category')->where(['id' => (int) $id])->get()->first();
    }
    public function getAll($pretty_id = false)
    {
        $categories = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('media_category')->orderby('num')->get()->all();
        $categories = \array_map(function ($item) use($pretty_id) {
            if ($pretty_id) {
                $item['id'] = \preg_replace('/_/i', '-', $item['category_alias']);
            }
            $item['original_title'] = $item['category_name'];
            $item['title'] = \_($item['category_name']);
            $item['censored'] = (bool) $item['censored'];
            return $item;
        }, $categories);
        return $categories;
    }
}
