<?php

namespace Ministra\Lib;

use Exception;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9;
class Weather implements \Ministra\Lib\StbApi\Weather
{
    protected $provider;
    public function __construct()
    {
        $this->provider = $this->getProvider();
    }
    private function getProvider()
    {
        $class = __NAMESPACE__ . '\\' . \ucfirst(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::getSafe('weather_provider', 'weatherco'));
        if (!\class_exists($class)) {
            throw new \Exception('Resource "' . $class . '" does not exist');
        }
        return new $class();
    }
    public function getCurrent()
    {
        return $this->provider->getCurrent();
    }
    public function getForecast()
    {
        return $this->provider->getForecast();
    }
    public function updateFullCurrent()
    {
        return $this->provider->updateFullCurrent();
    }
    public function updateFullForecast()
    {
        return $this->provider->updateFullForecast();
    }
    public function getCities($country, $search = '')
    {
        return $this->provider->getCities($country, $search);
    }
    public function getCityFieldName()
    {
        return $this->provider->getCityFieldName();
    }
}
