<?php

namespace Ministra\Lib;

use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
class Widget
{
    public $db;
    public $widget_name;
    public $cache_table;
    public $cache_expire = 3600;
    public $rss_url;
    public $rss_fields = [];
    public $rss_atributes = [];
    public function __construct()
    {
        $this->db = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance();
        $this->cache_table = 'rss_cache_' . $this->widget_name;
    }
    public function getData()
    {
        return $this->getDataFromDBCache();
    }
    private function getDataFromDBCache()
    {
        $content = $this->db->get($this->cache_table)->first('content');
        $content = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::U14f6e17e22660d6a254d5165f6a0c21d(\base64_decode($content));
        if (\is_array($content)) {
            return $content;
        }
        return 0;
    }
    public function getDataFromRSS()
    {
        $rss_new = [];
        $rss = \simplexml_load_file($this->rss_url);
        if ($rss) {
            foreach ($rss->channel->item as $item) {
                $new_item = [];
                foreach ($this->rss_fields as $field) {
                    $new_item[$field] = (string) $item->{$field};
                }
                foreach ($this->rss_atributes as $atribute) {
                    $new_item['attributes_' . $atribute] = (string) $item->enclosure->attributes()->{$atribute};
                }
                $rss_new[] = $new_item;
            }
            $this->setDataDBCache($rss_new);
            return $rss_new;
        }
    }
    private function setDataDBCache($arr)
    {
        $content = \base64_encode(\Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\b009b335728cd8e4f099e9618546ca1d9\fa1bbe77f401c6a3f5707becb14513ad::S5a834ad0c359b07af270f692de5f7106($arr));
        $result = $this->db->get($this->cache_table);
        if (\md5($content) != $result->first('crc')) {
            $data = ['content' => $content, 'updated' => 'NOW()', 'url' => $this->rss_url, 'crc' => \md5($content)];
            if ($result->count() == 1) {
                $this->db->update($this->cache_table, $data);
            } else {
                $this->db->insert($this->cache_table, $data);
            }
        }
    }
}
