<?php

\ob_start();
\session_start();
require __DIR__ . '/common.php';
use Ministra\Lib\Admin;
use Ministra\Lib\AdminAccess;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
$error = '';
$action_name = 'add';
$action_value = \_('Add');
\Ministra\Lib\Admin::checkAuth();
\Ministra\Lib\Admin::checkAccess(\Ministra\Lib\AdminAccess::ACCESS_VIEW);
$groups = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('admin_groups')->get()->all();
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if (!empty($_POST['add']) && !empty($_POST['name'])) {
    \Ministra\Lib\Admin::checkAccess(\Ministra\Lib\AdminAccess::ACCESS_CREATE);
    $data = ['name' => $_POST['name']];
    $group_id = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->insert('admin_groups', $data)->insert_id();
    $access_map = \Ministra\Lib\AdminAccess::convertPostParamsToAccessMap($_POST);
    if (!empty($access_map)) {
        $access_map = \array_map(function ($item) use($group_id) {
            $item['gid'] = $group_id;
            return $item;
        }, $access_map);
        if (!empty($access_map)) {
            \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->insert('acl', $access_map);
        }
    }
    \header('Location: admin_groups.php');
    exit;
}
if (!empty($id)) {
    if (!empty($_POST['edit_action']) && !empty($_POST['name'])) {
        \Ministra\Lib\Admin::checkAccess(\Ministra\Lib\AdminAccess::ACCESS_EDIT);
        $data = ['name' => $_POST['name']];
        \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->update('admin_groups', $data, ['id' => $id]);
        $access_map = \Ministra\Lib\AdminAccess::convertPostParamsToAccessMap($_POST);
        if (!empty($access_map)) {
            $access_map = \array_map(function ($item) use($id) {
                $item['gid'] = $id;
                return $item;
            }, $access_map);
            \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->delete('acl', ['gid' => $id]);
            \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->insert('acl', $access_map);
        }
        \header('Location: admin_groups.php');
        exit;
    } elseif (!empty($_GET['del'])) {
        \Ministra\Lib\Admin::checkAccess(\Ministra\Lib\AdminAccess::ACCESS_DELETE);
        \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->delete('admin_groups', ['id' => $id]);
        \header('Location: admin_groups.php');
        exit;
    }
}
if (isset($_GET['edit']) && !empty($id)) {
    $action_name = 'edit_action';
    $action_value = \_('Save');
    $edit_group = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('admin_groups')->where(['id' => $id])->get()->first();
    $access = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->from('acl')->where(['gid' => $id])->get()->all();
    $edit_group['access'] = [];
    foreach ($access as $row) {
        $edit_group['access'][$row['page']] = $row;
    }
}
?>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title><?php 
echo \_('Administrators groups');
?></title>
    <style type="text/css">

        body {
            font-family: Arial, Helvetica, sans-serif;
            font-weight: bold;
        }

        td {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 14px;
            text-decoration: none;
            color: #000000;
        }

        .list, .list td, .form {
            border-width: 1px;
            border-style: solid;
            border-color: #E5E5E5;
        }

        a {
            color: #0000FF;
            font-weight: bold;
            text-decoration: none;
        }

        a:link, a:visited {
            color: #5588FF;
            font-weight: bold;
        }

        a:hover {
            color: #0000FF;
            font-weight: bold;
            text-decoration: underline;
        }

        .access tr {
            background-color: #fff;
        }

        .access tr:hover {
            background-color: #EFF5FB;
        }

        .access td {
            text-align: center;
        }
    </style>

    <script type="text/javascript" src="../adm/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript">

    $(function () {
      $('.select_all').click(function () {

        var th_idx = $(this).parent().index();

        var col_checked = $(this).attr('checked');

        var table = $('.access');

        table.find('td').filter(function () {

          if ($(this).index() === th_idx) {
            if (col_checked) {
              $(this).find('input[type="checkbox"]').attr('checked', col_checked);
            } else {
              $(this).find('input[type="checkbox"]').removeAttr('checked');
            }
          }

        });

      });
    });

    </script>
</head>
<body>
<table align="center" border="0" cellpadding="0" cellspacing="0" width="800">
    <tr>
        <td align="center" valign="middle" width="100%" bgcolor="#88BBFF">
            <font size="5px" color="White"><b>&nbsp;&nbsp;<?php 
echo \_('Administrators groups');
?>
                    &nbsp;&nbsp;</b></font>
        </td>
    </tr>
    <tr>
        <td width="100%" align="left" valign="bottom">
            <a href="administrators.php"><< <?php 
echo \_('Back');
?></a>
        </td>
    </tr>
    <tr>
        <td align="center">
            <font color="Red">
                <strong>
                    <?php 
echo @$error;
?>
                </strong>
            </font>
            <br>
            <br>
        </td>
    </tr>
    <tr>
        <td align="center">
            <table class='list' cellpadding='3' cellspacing='0'>
                <tr>
                    <td><?php 
echo \_('Name');
?></td>
                    <td>&nbsp;</td>
                </tr>
                <?php 
foreach ($groups as $group) {
    echo '<td>' . $group['name'] . '</td>';
    echo '<td>';
    echo '<a href="?edit=1&id=' . $group['id'] . '">edit</a>&nbsp;';
    echo '<a href="?del=1&id=' . $group['id'] . '" onclick="if(confirm(\'' . \_('Do you really want to delete this record?') . '\')){return true}else{return false}">del</a>';
    echo '</td>';
    echo '</tr>';
}
?>
            </table>
        </td>
    </tr>
    <tr>
        <td align="center">
            <br>
            <br>
            <form method="POST">
                <table class="form" width="600">
                    <tr>
                        <td width="100"><?php 
echo \_('Name');
?></td>
                        <td><input type="text" name="name" size="30" value="<?php 
echo @$edit_group['name'];
?>"/></td>
                    </tr>

                    <!-- todo: access table-->
                    <tr>
                        <td colspan="2">
                            <table width="100%" class="access">
                                <tr>
                                    <th></th>
                                    <th><input type="checkbox" class="select_all"/><br>view</th>
                                    <th><input type="checkbox" class="select_all"/><br>create</th>
                                    <th><input type="checkbox" class="select_all"/><br>edit</th>
                                    <th><input type="checkbox" class="select_all"/><br>delete</th>
                                    <th><input type="checkbox" class="select_all"/><br>action</th>
                                    <th><input type="checkbox" class="select_all"/><br>context action</th>
                                </tr>
                                <?php 
$pages = \scandir(\PROJECT_PATH . '/administrator/');
$exclude_pages = ['ad.php', 'common.php', 'get.php', 'get_img.php', 'index.php', 'administrators.php', 'load.php', 'login.php', 'logout.php'];
$pages = \array_filter($pages, function ($page) use($exclude_pages) {
    return \strpos($page, '.php') && \array_search($page, $exclude_pages) === \false;
});
foreach ($pages as $page) {
    $page_name = \str_replace('.php', '', $page);
    echo '<tr>';
    echo '<td style="text-align: left">';
    echo $page;
    echo '<input type="hidden" name="page" value="' . $page_name . '">';
    echo '</td>';
    echo '<td>';
    echo '<input name="view[' . $page_name . ']" value="1" type="checkbox" ' . (!empty($edit_group['access'][$page_name]['view']) ? 'checked' : '') . '/>';
    echo '</td>';
    echo '<td>';
    echo '<input name="create[' . $page_name . ']" value="1" type="checkbox" ' . (!empty($edit_group['access'][$page_name]['create']) ? 'checked' : '') . '/>';
    echo '</td>';
    echo '<td>';
    echo '<input name="edit[' . $page_name . ']" value="1" type="checkbox" ' . (!empty($edit_group['access'][$page_name]['edit']) ? 'checked' : '') . '/>';
    echo '</td>';
    echo '<td>';
    echo '<input name="delete[' . $page_name . ']" value="1" type="checkbox" ' . (!empty($edit_group['access'][$page_name]['delete']) ? 'checked' : '') . '/>';
    echo '</td>';
    echo '<td>';
    echo '<input name="page_action[' . $page_name . ']" value="1" type="checkbox" ' . (!empty($edit_group['access'][$page_name]['page_action']) ? 'checked' : '') . '/>';
    echo '</td>';
    echo '<td>';
    echo '<input name="context_action[' . $page_name . ']" value="1" type="checkbox" ' . (!empty($edit_group['access'][$page_name]['context_action']) ? 'checked' : '') . '/>';
    echo '</td>';
    echo '</tr>';
}
?>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td><input type="submit" name="<?php 
echo $action_name;
?>"
                                   value="<?php 
echo $action_value;
?>"/></td>
                    </tr>
                </table>
            </form>
        </td>
    </tr>
</table>
</body>
</html>

