<?php

require __DIR__ . '/common.php';
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9;
use Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13;
use Ministra\Lib\SysEvent;
$enable_internal_billing = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::getSafe('enable_internal_billing', \false);
$end_billing_interval = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::getSafe('number_of_days_to_send_message', \false);
if (!empty($enable_internal_billing) && !empty($end_billing_interval) && \is_numeric($end_billing_interval)) {
    $locales = [];
    $allowed_locales = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::get('allowed_locales');
    $default_locale = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\E0f1497c1499ac20875f2ad18485909a9::get('default_locale');
    \bindtextdomain('stb', \PROJECT_PATH . '/locale');
    \textdomain('stb');
    \bind_textdomain_codeset('stb', 'UTF-8');
    $users = \Ministra\Lib\e7ad172977eb8d4fc1927f1037c2a8f5\O7d24a478f79395d954dd4b4b90a76a13::getInstance()->select(['id', '(TO_DAYS(`expire_billing_date`) - TO_DAYS(NOW())) as `end_billing_days`', 'locale'])->from('`users`')->where(["(TO_DAYS(`expire_billing_date`) - TO_DAYS(NOW())) <= '{$end_billing_interval}' " . "AND CAST(`expire_billing_date` AS CHAR) <> '0000-00-00 00:00:00' AND 1=" => 1, 'status' => 0])->get()->all();
    $event = new \Ministra\Lib\SysEvent();
    $event->setTtl(86340);
    $msg_more = 'Dear Subscriber! Your payment term will expire in "%s" days. ' . 'Please refill a personal account in order to avoid tripping of services.';
    $msg_today = 'Dear Subscriber! Your payment term will expire today. ' . 'Please refill a personal account in order to avoid tripping of services.';
    $msg = '';
    $locale = $default_locale;
    foreach ($users as $user) {
        $current_local = \setlocale(\LC_MESSAGES, 0);
        $event->setUserListById($user['id']);
        if (\in_array($user['locale'], $allowed_locales)) {
            $locale = $user['locale'];
        } else {
            $locale = $default_locale;
        }
        \putenv("LC_MESSAGES={$locale}");
        \putenv("LANGUAGE={$locale}");
        \setlocale(\LC_MESSAGES, $locale);
        $msg = $user['end_billing_days'] > 0 ? \sprintf(\_($msg_more), $user['end_billing_days']) : \_($msg_today);
        $event->sendMsg($msg);
    }
}
